"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mysqlConfig = void 0;
const user_entity_1 = require("../entities/user.entity");
const vendor_entity_1 = require("../entities/vendor.entity");
const customer_entity_1 = require("../entities/customer.entity");
const product_entity_1 = require("../entities/product.entity");
const category_entity_1 = require("../entities/category.entity");
const order_entity_1 = require("../entities/order.entity");
const cart_entity_1 = require("../entities/cart.entity");
const address_entity_1 = require("../entities/address.entity");
exports.mysqlConfig = {
    type: 'mysql',
    host: process.env.DB_HOST || 'localhost',
    port: parseInt(process.env.DB_PORT ?? '3306', 10),
    username: process.env.DB_USERNAME || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'ecommerce_db',
    entities: [
        user_entity_1.User,
        vendor_entity_1.Vendor,
        customer_entity_1.Customer,
        product_entity_1.Product,
        category_entity_1.Category,
        order_entity_1.Order,
        cart_entity_1.Cart,
        address_entity_1.Address,
    ],
    synchronize: false,
    logging: true,
    timezone: '+00:00',
};
//# sourceMappingURL=mysql.config.js.map